//
//  SubForm07ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/12/26.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm07ViewController.h"

@interface SubForm07ViewController ()

@end

@implementation SubForm07ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    [self btnViewSetting:btnRepeatClick];
    [self btnViewSetting:btnBack];
    
    flgTimer = false;
    mCount = 0;
    
    nmsSetLine = 0;
    nmsSetCount = 0;
    nmsSetMsec = 0;
    
    txtLine.delegate = self;
    txtMsec.delegate = self;
    txtCount.delegate = self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL) isDigit:(NSString*) inString
{
    if(inString == nil || [inString isEqualToString:@""])
    {
        return NO;
    }
    
    NSCharacterSet* digitCharSet = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
    
    NSScanner* aScan = [NSScanner localizedScannerWithString:inString];
    [aScan setCharactersToBeSkipped:nil];
    
    [aScan scanCharactersFromSet:digitCharSet intoString:NULL];
    return [aScan isAtEnd];
}

-(bool) inputValueCheck
{
    if(![self isDigit:[txtLine text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Line is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtMsec text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Mill section is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    if(![self isDigit:[txtCount text]])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Count is invalid."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return false;
    }
    
    return true;
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self timerStop];
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)pushRepeatClick:(UIButton *)sender
{
    if(!flgTimer)
    {
        if(![self inputValueCheck])
        {
            return;
        }
        
        nmsSetLine = [[txtLine text] intValue];
        nmsSetMsec = [[txtMsec text] intValue];
        nmsSetCount = [[txtCount text] intValue];
        
        int nmsInterval = nmsSetMsec / 1000;
        
        if([sgmCutType selectedSegmentIndex] == 0)
        {
            flgCutON = true;
        }
        else
        {
            flgCutON = false;
        }
        
        flgTimer = true;
        [btnRepeatClick setTitle:@"Repeat printS Stop" forState:UIControlStateNormal];
        [btnRepeatClick setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
        
        // timer start
        mCount = 0;
        objTimer = [NSTimer scheduledTimerWithTimeInterval:nmsInterval target:self selector:@selector(repeatPrint:) userInfo:nil repeats:YES];
            
        
    }
    else
    {
        // timer stop
        [self timerStop];
    }
    

}

-(void) timerStop
{
    [objTimer invalidate];
    flgTimer = false;
    [btnRepeatClick setTitle:@"Repeat print Start" forState:UIControlStateNormal];
    [btnRepeatClick setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
}

-(void) repeatPrint : (NSTimer*) timer
{
    int io_jobid = 0;
    NSMutableString* title = nil;
    
    NSMutableString* putStr = [NSMutableString string];
    
    for(int n = 0; n < nmsSetLine; n++)
    {
        [putStr appendString:@"\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A"];
    }

    [putStr appendString:@"1B4A50"];
    if(flgCutON)
    {
        [putStr appendString:@"1B6D"];
    }
    
    mCount++;
    int nmsRet = [mObjLib NPrint: mStrPrtName :putStr : (int)[putStr length] :&io_jobid];
    if(nmsRet != 0)
    {
        if(flgTimer)
        {
            [objTimer invalidate];
            flgTimer = false;
        }

        title = [[NSString stringWithFormat:@"%d times stop!!", mCount] mutableCopy];
    }
    else
    {
        
        
        if(nmsSetCount != 0 && mCount >= nmsSetCount)
        {
            [objTimer invalidate];
            flgTimer = false;
            title = [[NSString stringWithFormat:@"%d times OK. Finish!", mCount] mutableCopy];
        }
        else
        {
            title = [[NSString stringWithFormat:@"%d times OK", mCount] mutableCopy];
        }
    }
    
    [lblResult setText:title];
    [self setReturnCode : nmsRet];

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil)
    {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

@end
